var nFindAPITries = 0;
var maxTries = 500;
var api = null;

// The ScanForAPI() function searches for an object named API_1484_11
// in the window that is passed into the function. If the object is
// found a reference to the object is returned to the calling function.
// If the instance is found the SCO now has a handle to the LMS
// provided API Instance. The function searches a maximum number
// of parents of the current window. If no object is found the
// function returns a null reference. This function also reassigns a
// value to the win parameter passed in, based on the number of
// parents. At the end of the function call, the win variable will be
// set to the upper most parent in the chain of parents.
function ScanForAPI(win)
{
	while ((win.API_1484_11 == null) && (win.parent != null) && (win.parent != win))
	{
		nFindAPITries++;
		if (nFindAPITries > maxTries)
		{
			return null;
		}
		win = win.parent;
	}
	return win.API_1484_11;
}

// The GetAPI() function begins the process of searching for the LMS
// provided API Instance. The function takes in a parameter that
// represents the current window. The function is built to search in a
// specific order and stop when the LMS provided API Instance is found.
// The function begins by searching the current window’s parent, if the
// current window has a parent. If the API Instance is not found, the
// function then checks to see if there are any opener windows. If
// the window has an opener, the function begins to look for the
// API Instance in the opener window.
function GetAPI(win)
{
	if ((win.parent != null) && (win.parent != win))
	{
		api = ScanForAPI(win.parent);
	}
	if ((api == null) && (win.opener != null))
	{
		api = ScanForAPI(win.opener);
	}
}


function APIInitialize() {
	api.Initialize("");
}

function APICommit() {
	return api.Commit("");
}

function APIGetStudentName() {
	return api.GetValue("cmi.learner_name");
}

function APIGetStudentID() {
	return api.GetValue("cmi.learner_id");
}

function APIGetStudentLang() {
	return api.GetValue("cmi.learner_preference.language");
}

function APISetStatus(status) {
	api.SetValue("cmi.completion_status", "completed");
	return api.SetValue("cmi.success_status", status);
}

function APISetScore(score, scaled_score) {
	api.SetValue("cmi.score.scaled", scaled_score);
	return api.SetValue("cmi.score.raw", score);
}

function APISetProgress(scaled_progress) {
	return api.SetValue("cmi.progress_measure", scaled_progress);
}
