var findAPITries = 0;
var api = null;

function findAPI(win)
{
	// Check to see if the window (win) contains the API
	// if the window (win) does not contain the API and
	// the window (win) has a parent window and the parent window
	// is not the same as the window (win)
	while ( (win.API == null) && (win.parent != null) && (win.parent != win) )
	{
		// increment the number of findAPITries
		findAPITries++;

		// Note: 7 is an arbitrary number, but should be more than sufficient
		if (findAPITries > 7)
		{
			alert("Error finding API -- too deeply nested.");
			return null;
		}

		// set the variable that represents the window being
		// being searched to be the parent of the current window
		// then search for the API again
		win = win.parent;
	}
	return win.API;
}

function GetAPI(win)
{
	// start by looking for the API in the current window
	api = findAPI(win);

	// if the API is null (could not be found in the current window)
	// and the current window has an opener window
	if ( (api == null) && (win.opener != null) && (typeof(win.opener) != "undefined") )
	{
		// try to find the API in the current window’s opener
		api = findAPI(win.opener);
	}
	// if the API has not been found
	if (api == null)
	{
		// Alert the user that the API Adapter could not be found
		alert("Unable to find an API adapter");
	}
}

function APIInitialize() {
	api.LMSInitialize("");
}

function APICommit() {
	return api.LMSCommit("");
}

function APIGetStudentName() {
	return api.LMSGetValue("cmi.core.student_name");
}

function APIGetStudentID() {
	return api.LMSGetValue("cmi.core.student_id");
}

function APIGetStudentLang() {
	return api.LMSGetValue("cmi.student_preference.language");
}

function APISetStatus(status) {
	return api.LMSSetValue("cmi.core.lesson_status", status);
}

function APISetScore(score, scaled_score) {
	return api.LMSSetValue("cmi.core.score.raw", score);
}

function APISetProgress(scaled_progress) {
	return null;
}
